SET NOEXEC OFF
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON

IF [dbo].[ISSAM4]() = 1
  BEGIN
    SET NOEXEC ON
  END
GO

SET QUOTED_IDENTIFIER ON

DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = '
IF EXISTS
  (SELECT DAT.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[diary] DIA
                     INNER JOIN [dbo].[DiaryAttachments] DAT
                             ON DAT.[DIARYID] = DIA.[ACTIONID]
                  ON DIA.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Diary Attachments Found''
    SELECT DAT.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                      INNER JOIN [dbo].[DiaryAttachments] DAT
                              ON DAT.[DIARYID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT DAT.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[DiaryAttachments] DAT
                  ON DAT.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Diary Attachments Found (2)''
    SELECT DAT.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[DiaryAttachments] DAT
                   ON DAT.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT DEL.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[diary] DIA
                     INNER JOIN [dbo].[DiaryDelegations] DEL
                             ON DEL.[ACTIONID] = DIA.[ACTIONID]
                  ON DIA.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Diary Delegations Found''
    SELECT DEL.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                      INNER JOIN [dbo].[DiaryDelegations] DEL
                              ON DEL.[ACTIONID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT DIA.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[diary] DIA
                  ON DIA.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Diary Entries Found''
    SELECT DIA.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[diary] DIA
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT CUF.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[CaseUDFAnswers] CUF
                  ON CUF.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Case UDF Answers Found''
    SELECT CUF.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[CaseUDFAnswers] CUF
                   ON CUF.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT MAL.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[MatterLedger] MAL
                  ON MAL.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Matter Ledger Entries Found''
    SELECT MAL.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[MatterLedger] MAL
                   ON MAL.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT TIE.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[TimeEntry] TIE
                  ON TIE.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Time Entries Found''
    SELECT TIE.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[TimeEntry] TIE
                   ON TIE.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT TDB.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[TimeDayBook] TDB
                  ON TDB.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Time Day Book Entries Found''
    SELECT TDB.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[TimeDayBook] TDB
                   ON TDB.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT UND.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[Undertakings] UND
                  ON UND.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Undertakings Found''
    SELECT UND.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[Undertakings] UND
                   ON UND.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

IF [dbo].[ISSAM4]() = 0
  BEGIN
    SET @COMMAND = '
IF EXISTS
  (SELECT BD.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[BillHeader] BH
                     INNER JOIN [dbo].[BillDetails] BD
                             ON BD.[DRAFTNO] = BH.[DRAFTNO]
                  ON BH.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Bill Details Found''
    SELECT BD.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[BillHeader] BH
                      INNER JOIN [dbo].[BillDetails] BD
                              ON BD.[DRAFTNO] = BH.[DRAFTNO]
                   ON BH.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

    EXEC (@COMMAND)
  END

IF [dbo].[ISSAM4]() = 0
  BEGIN
    SET @COMMAND = '
IF EXISTS
  (SELECT BL.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[BillHeader] BH
                     INNER JOIN [dbo].[BillLogging] BL
                             ON BL.[DRAFTNO] = BH.[DRAFTNO]
                  ON BH.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Bill Logging Found''
    SELECT BL.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[BillHeader] BH
                      INNER JOIN [dbo].[BillLogging] BL
                              ON BL.[DRAFTNO] = BH.[DRAFTNO]
                   ON BH.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

    EXEC (@COMMAND)
  END

IF [dbo].[ISSAM4]() = 0
  BEGIN
    SET @COMMAND = '
IF EXISTS
  (SELECT BF.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[BillFeeBreakDown] BF
                  ON BF.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Bill Fee Breakdowns Found''
    SELECT BF.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[BillFeeBreakDown] BF
                   ON BF.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

    EXEC (@COMMAND)
  END

IF [dbo].[ISSAM4]() = 0
  BEGIN
    SET @COMMAND = '
IF EXISTS
  (SELECT BH.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[BillHeader] BH
                  ON BH.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Bill Headers Found''
    SELECT BH.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[BillHeader] BH
                   ON BH.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

    EXEC (@COMMAND)
  END

IF [dbo].[ISSAM4]() = 0
  BEGIN
    SET @COMMAND = '
IF EXISTS
  (SELECT BD.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[BatchH] BH
                     INNER JOIN [dbo].[BatchDetails] BD
                             ON BD.[BATCHNO] = BH.[BATCHNO]
                  ON BH.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Batch Details Found''
    SELECT BD.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[BatchH] BH
                      INNER JOIN [dbo].[BatchDetails] BD
                              ON BD.[BATCHNO] = BH.[BATCHNO]
                   ON BH.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

    EXEC (@COMMAND)
  END

IF [dbo].[ISSAM4]() = 0
  BEGIN
    SET @COMMAND = '
IF EXISTS
  (SELECT BH.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[BatchH] BH
                  ON BH.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Batch Headers Found''
    SELECT BH.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[BatchH] BH
                   ON BH.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

    EXEC (@COMMAND)
  END

SET @COMMAND = '
IF EXISTS
  (SELECT CSM.*
     FROM [dbo].[CaseMaster] CSM
          LEFT OUTER JOIN [dbo].[matters] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
    WHERE MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Case Master Records Found''
    SELECT CSM.*
      FROM [dbo].[CaseMaster] CSM
           LEFT OUTER JOIN [dbo].[matters] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
     WHERE MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT DAT.*
     FROM [dbo].[CaseMasterClosed] CSM
          LEFT OUTER JOIN [dbo].[Closed] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[closediary] DIA
                     INNER JOIN [dbo].[CloseDiaryAttachments] DAT
                             ON DAT.[DIARYID] = DIA.[ACTIONID]
                  ON DIA.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Close Diary Attachments Found''
    SELECT DAT.*
      FROM [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                      INNER JOIN [dbo].[CloseDiaryAttachments] DAT
                              ON DAT.[DIARYID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT DAT.*
     FROM [dbo].[CaseMasterClosed] CSM
          LEFT OUTER JOIN [dbo].[Closed] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[CloseDiaryAttachments] DAT
                  ON DAT.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Close Diary Attachments Found (2)''
    SELECT DAT.*
      FROM [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[CloseDiaryAttachments] DAT
                   ON DAT.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT DEL.*
     FROM [dbo].[CaseMasterClosed] CSM
          LEFT OUTER JOIN [dbo].[Closed] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[closediary] DIA
                     INNER JOIN [dbo].[DiaryDelegations] DEL
                             ON DEL.[ACTIONID] = DIA.[ACTIONID]
                  ON DIA.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned "Closed" Diary Delegations Found''
    SELECT DEL.*
      FROM [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                      INNER JOIN [dbo].[DiaryDelegations] DEL
                              ON DEL.[ACTIONID] = DIA.[ACTIONID]
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT DIA.*
     FROM [dbo].[CaseMasterClosed] CSM
          LEFT OUTER JOIN [dbo].[Closed] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[closediary] DIA
                  ON DIA.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Closed Diary Entries Found''
    SELECT DIA.*
      FROM [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[closediary] DIA
                   ON DIA.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

SET @COMMAND = '
IF EXISTS
  (SELECT CUF.*
     FROM [dbo].[CaseMasterClosed] CSM
          LEFT OUTER JOIN [dbo].[Closed] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[ClosedCaseUDFAnswers] CUF
                  ON CUF.[CASECODE] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Closed Case UDF Answers Found''
    SELECT CUF.*
      from [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[ClosedCaseUDFAnswers] CUF
                   ON CUF.[CASECODE] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)

IF [dbo].[ISSAM4]() = 0
  BEGIN
    SET @COMMAND = '
IF EXISTS
  (SELECT MAL.*
     FROM [dbo].[CaseMasterClosed] CSM
          LEFT OUTER JOIN [dbo].[Closed] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
          INNER JOIN [dbo].[ClosedMatterLedger] MAL
                  ON MAL.[MATTER] = CSM.[CSCODE]
    WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
      AND MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Closed Matter Ledger Entries Found''
    SELECT MAL.*
      FROM [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
           INNER JOIN [dbo].[ClosedMatterLedger] MAL
                   ON MAL.[MATTER] = CSM.[CSCODE]
     WHERE RTRIM(ISNULL(CSM.[CSCODE], '''')) NOT IN (''~'', '''')
       AND MAT.[Code] IS NULL
  END'

    EXEC (@COMMAND)
  END

SET @COMMAND = '
IF EXISTS
  (SELECT CSM.*
     FROM [dbo].[CaseMasterClosed] CSM
          LEFT OUTER JOIN [dbo].[Closed] MAT
                       ON MAT.[Code] = CSM.[CSCODE]
    WHERE MAT.[Code] IS NULL)
  BEGIN
    SELECT ''Orphaned Closed Case Master Records Found''
    SELECT CSM.*
      FROM [dbo].[CaseMasterClosed] CSM
           LEFT OUTER JOIN [dbo].[Closed] MAT
                        ON MAT.[Code] = CSM.[CSCODE]
     WHERE MAT.[Code] IS NULL
  END'

EXEC (@COMMAND)
GO

IF EXISTS
  (  SELECT BBG.*
       FROM (  SELECT CSC.[CSCODE],
                      COUNT(1) AS [TOTAL]
                 FROM [dbo].[CaseMasterClosed] CSC
             GROUP BY CSC.[CSCODE]
               HAVING COUNT(1) > 1) GBS
            INNER JOIN [dbo].[CaseMasterClosed] BBG
                    ON BBG.[CSCODE] = GBS.[CSCODE])
  BEGIN
      SELECT 'NON UNIQUE CLOSE CASE MASTER ENTRIES FOUND. THIS MUST BE ADDRESSED MANUALLY. THE UPGRADE WILL FAIL IF YOU DO NOT DO THIS.'
      SELECT BBG.*
        FROM (  SELECT CSC.[CSCODE],
                       COUNT(1) AS [TOTAL]
                  FROM [dbo].[CaseMasterClosed] CSC
              GROUP BY CSC.[CSCODE]
                HAVING COUNT(1) > 1) GBS
             INNER JOIN [dbo].[CaseMasterClosed] BBG
                     ON BBG.[CSCODE] = GBS.[CSCODE]
    ORDER BY BBG.[CSCODE],
             BBG.[FILENUM]
  END
GO

SET NOEXEC OFF
